# A Tcl script for the Qsys system console

# Start Qsys, open your soc_system.qsys file, run File->System Console,
# then execute this script by selecting it with Ctrl-E

# The System Console is described in Chapter 10 of Volume III of
# the Quartus II Handbook

# Alternately,
# system-console --project_dir=. --script=syscon-test.tcl
#
# system-console --project_dir=. -cli
#   and then "source syscon-test.tcl"

# Base addresses of the peripherals: take from Qsys
set vga_led 0x0

puts "Started system-console-test-script"

# Using the JTAG chain, check the clock and reset"

set j [lindex [get_service_paths jtag_debug] 0]
open_service jtag_debug $j
puts "Opened jtag_debug"

puts "Checking the JTAG chain loopback: [jtag_debug_loop $j {1 2 3 4 5 6}]"
jtag_debug_reset_system $j

puts -nonewline "Sampling the clock: "
foreach i {1 1 1 1 1 1 1 1 1 1 1 1} {
    puts -nonewline [jtag_debug_sample_clock $j]
}
puts ""

puts "Checking reset state: [jtag_debug_sample_reset $j]"

close_service jtag_debug $j
puts "Closed jtag_debug"

# Perform bus reads and writes

set m [lindex [get_service_paths master] 0]
open_service master $m
puts "Opened master"

# Write a test pattern to the various registers
#foreach { r v } {0 0xff 1 0x1 2 0x2 3 0x4 4 0x8 5 0x10 6 0x20 7 0x40} {
foreach { r v } { 
0 96 
2 25 
4 -5 
6 10 
8 -15
10 5
12 -15 
14 0
16 0 
18 175 
20 250
22 2
24 1 
26 55 
28 1
30 1 
32 3 
34 3 
36 5 
38 5 
40 0 
42 0
44 2
46 4
48 6
50 50 
52 60 
54 70 
56 80 
58 90 
60 100 
62 100
64 110
66 120} {
        master_write_16 $m [expr $vga_led + $r] $v
        puts $v 
}
puts "read finished -sleep start"
#after 5000
puts "woken up - read start"
foreach { i } { 0 2 4 6 8} {
	puts $i
	puts [ master_read_16 $m [expr $vga_led + $i ] 1]
	
}

close_service master $m
puts "Closed master"




